//
//  Support.m
//  GCD Beispiele
//
//  Created by Kai Brüning on 18.10.09.
//  Copyright 2009 Heise. All rights reserved.
//

#import "Support.h"
#import <Foundation/Foundation.h>


int CountWords(const char* filePath) {
	NSAutoreleasePool* pool = [[NSAutoreleasePool alloc] init];
	
	NSString* path = [NSString stringWithUTF8String:filePath];
	
	NSError* error = nil;
	NSStringEncoding encoding;
	NSString* fileContents = [NSString stringWithContentsOfFile:path
												   usedEncoding:&encoding
														  error:&error];
	if (!fileContents) {
		NSLog(@"Could not open %s, error %@", filePath, error);
		return 0;
	}
	
	__block int count;
	// Die folgende Schleife macht die Verarbeitung langsamer, um zum Beispiel den Verlauf
	// besser mit Instruments oder dem Aktivitätsmonitor verfolgen zu können.
	//for (int i = 0; i < 500; i++) {
	//	NSAutoreleasePool* innerPool = [[NSAutoreleasePool alloc] init];
		count = 0;
		[fileContents enumerateSubstringsInRange:NSMakeRange(0, fileContents.length)
										 options:NSStringEnumerationByWords | NSStringEnumerationSubstringNotRequired
									  usingBlock:^(NSString* substring, NSRange substringRange, NSRange enclosingRange, BOOL* stop) {
										  ++count;
									  }
		];
		
	//	[innerPool drain];
	//}
	
	[pool drain];

	return count;
}


void CollectTextFiles(int pathCount, const char* paths[], int* outFileCount, const char*** outFilePaths) {
	NSCParameterAssert(outFileCount);
	NSCParameterAssert(outFilePaths);

	NSAutoreleasePool* pool = [[NSAutoreleasePool alloc] init];

	NSFileManager* fileManager = [NSFileManager defaultManager];
	
	NSMutableArray* fileURLs = [NSMutableArray array];
	
	for (int i = 0; i < pathCount; i++) {
		NSString* uti;
		NSError*  error;

		//if ([fileManager fileExistsAtPath:path isDirectory:&isDirectory])
		NSString* path = [[NSString stringWithUTF8String:paths[i]] stringByExpandingTildeInPath];
		NSURL* url = [NSURL fileURLWithPath:path];
		NSNumber* isDirectory;
		// Ignore the path if it does not exist.
		if ([url getResourceValue:&isDirectory forKey:NSURLIsDirectoryKey error:&error]) {
			if ([isDirectory boolValue]) {
				NSDirectoryEnumerator* enumerator = [fileManager enumeratorAtURL:(NSURL *)url
													  includingPropertiesForKeys:[NSArray arrayWithObject:NSURLTypeIdentifierKey]
																		 options:
													 NSDirectoryEnumerationSkipsHiddenFiles | NSDirectoryEnumerationSkipsPackageDescendants
																	errorHandler:^BOOL(NSURL* url, NSError* error) {
																		NSLog(@"Error %@ enumerating directory %@\n",
																			  error, url);
																		return YES;	// weiter wenn möglich
																	}];
				
				for (NSURL* iURL in enumerator) {
					if ([iURL getResourceValue:&uti forKey:NSURLTypeIdentifierKey error:&error]) {
						if (UTTypeConformsTo((CFStringRef)uti, kUTTypeText))
							[fileURLs addObject:iURL];
					}
				}
			} else {
				// Path points to a file. Check whether it is a text file.
				if ([url getResourceValue:&uti forKey:NSURLTypeIdentifierKey error:&error]) {
					if (UTTypeConformsTo((CFStringRef)uti, kUTTypeText))
						[fileURLs addObject:url];
				}
			}
		}
	}
	
	char** filePaths = malloc(fileURLs.count * sizeof(const char*));
	
	char** iFilePath = filePaths;
	for (NSURL* iURL in fileURLs) {
		NSString* path = iURL.path;
		const char* cPath = [path fileSystemRepresentation];
		*iFilePath = malloc (strlen(cPath) + 1);
		strcpy(*iFilePath, cPath);
		iFilePath++;
	}

	*outFileCount = fileURLs.count;
	*outFilePaths = (const char**)filePaths;

	[pool drain];
}
